//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;

namespace RemotingSamples
{
	public class Client
	{
		public static int Main(string [] args)
		{
			try
			{
				TcpChannel chan = new TcpChannel();
				ChannelServices.RegisterChannel(chan);
				HelloServer obj = (HelloServer)Activator.GetObject(typeof(RemotingSamples.HelloServer),
					"tcp://localhost:8085/SayHello");
				while(true)
				{
					Console.WriteLine(obj.HelloMethod("Klient mwi: witaj."));
					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				System.Console.WriteLine("Nie mona odnale serwera");
				Console.WriteLine(e);
			} 
			return 0;
		}
	}
}

// Wyjtek zgaszany jeli nie mona uruchomi serwera:
// Unhandled Exception: System.Net.Sockets.SocketException: No connection could be
// made because the target machine actively refused it
//
//ServerStackTrace:
//   at System.Net.Sockets.Socket.Connect(EndPoint remoteEP)
//   at System.Runtime.Remoting.Channels.RemoteConnection.CreateNewSocket()
//   at System.Runtime.Remoting.Channels.RemoteConnection.GetSocket()
//   at System.Runtime.Remoting.Channels.SocketCache.GetSocket(String machineAndPort)
//   at System.Runtime.Remoting.Channels.Tcp.TcpClientTransportSink.SendRequestWithRetry(IMessage msg, ITransportHeaders requestHeaders, Stream requestStream)
//   at System.Runtime.Remoting.Channels.Tcp.TcpClientTransportSink.ProcessMessage(IMessage msg, ITransportHeaders requestHeaders, Stream requestStream, ITransportHeaders& responseHeaders, Stream& responseStream)
//   at System.Runtime.Remoting.Channels.BinaryClientFormatterSink.SyncProcessMessage(IMessage msg)
//
//Exception rethrown at [0]:
//   at System.Runtime.Remoting.Proxies.RealProxy.HandleReturnMessage(IMessage reqMsg, IMessage retMsg)
//   at System.Runtime.Remoting.Proxies.RealProxy.PrivateInvoke(MessageData& msgData, Int32 type)
//   at RemotingSamples.HelloServer.HelloMethod(String name) in C:\Program Files\Microsoft.NET\FrameworkSDK\Samples\quickstart\howto\samples\remoting\hello\cs\object.cs:line 14
//   at RemotingSamples.Client.Main(String[] args) in C:\Program Files\Microsoft.NET\FrameworkSDK\Samples\quickstart\howto\samples\remoting\hello\cs\client.cs:line 15